
void  __cdecl PPage(int ID, bool use_sound, const char* soundname, const char* rgb_colour, const char *Format, ...);
void PPage(int ID, const char* message, char* soundname = "paging_caution_2.wav", char* rgb_colour = "255,128,64" );

void Console(const char *Format, ...);
void VersionHook(int PlayerID,float Version);

bool ReadMemory(int Location, void* Buffer, int BufferLen);
bool WriteMemory(int Location, const void* Buffer, int BufferLen);
void StartButton_Glue();
void NoGameover_Glue();

class Hooking
{
public:
	static void Install();
	static void Uninstall();
	static int RunGame;
};

class Hook
{
private:
	char Backup[20];
	char HookPadding[10];
	int HookAddress;
	int Offset;
	bool IsInstalled;
public:
	Hook()
	{
		Offset = 0;
		IsInstalled = false;
	}
	bool Install(char OpCode, int Addr, int Glue, char *Padding)
	{
		if (Addr && Glue && !IsInstalled)
		{
			HookAddress = Addr;
			memcpy(HookPadding,Padding,(sizeof(Padding) > sizeof(HookPadding) ? sizeof(HookPadding) : sizeof(Padding)));
			HookPadding[10] = '\0';
			Offset = Glue - HookAddress - 5;
			ReadMemory(HookAddress, Backup, 5+strlen(Padding));
			WriteMemory(HookAddress, &OpCode, 1);
			WriteMemory(HookAddress+1, &Offset, 4);
			if (strlen(Padding) > 0)
			{
				WriteMemory(HookAddress+5, &Padding, strlen(Padding));
			}
			IsInstalled = true;
			return true;
		}
		return false;
	};
	bool Uninstall()
	{
		if (IsInstalled)
		{
			WriteMemory(HookAddress, Backup, 5+strlen(HookPadding));
			IsInstalled = false;
			return true;
		}
		return false;
	};
};